using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;
using Microsoft.Xna.Framework.Net;
using Microsoft.Xna.Framework.Storage;

namespace MojaPierwszaGraXNA
{
    /// <summary>
    /// This is the main type for your game
    /// </summary>
    public class Game1 : Microsoft.Xna.Framework.Game
    {
        GraphicsDeviceManager graphics;
        SpriteBatch spriteBatch;

        private BasicEffect efekt = null;
        
        Kwadryka sfera;

        public Game1()
        {
            Window.Title = "Modul 2. Owietlenie: Laboratorium rozszerzone";
            //Window.AllowUserResizing = true;

            graphics = new GraphicsDeviceManager(this);
            Content.RootDirectory = "Content";
        }

        /// <summary>
        /// Allows the game to perform any initialization it needs to before starting to run.
        /// This is where it can query for any required services and load any non-graphic
        /// related content.  Calling base.Initialize will enumerate through any components
        /// and initialize them as well.
        /// </summary>
        protected override void Initialize()
        {            
            sfera = Kwadryka.StworzSfere(graphics.GraphicsDevice, 0.75f, 100, 100, Color.White);            

            //efekt                        
            efekt = new BasicEffect(graphics.GraphicsDevice);
            efekt.VertexColorEnabled = false;

            //oswietlenie domyslne
            efekt.EnableDefaultLighting();
            efekt.DirectionalLight1.DiffuseColor = Color.Black.ToVector3();
            efekt.DirectionalLight1.SpecularColor = Color.Black.ToVector3();
            efekt.DirectionalLight2.DiffuseColor = Color.Black.ToVector3();
            efekt.DirectionalLight2.SpecularColor = Color.Black.ToVector3();

            this.IsFixedTimeStep = false;
            
            //macierz rzutowania                        
            efekt.Projection = Matrix.CreateOrthographic(2.0f * graphics.GraphicsDevice.Viewport.AspectRatio, 2.0f, 0.0f, 100.0f);
            //efekt.Projection = Matrix.CreatePerspective(2.0f * graphics.GraphicsDevice.Viewport.AspectRatio, 2.0f, 1.0f, 100.0f);

            //kamera
            //efekt.View = Matrix.CreateTranslation(0, 0, -1);
            efekt.View = Matrix.CreateLookAt(new Vector3(0, 0, 2), new Vector3(0, 0, 0), new Vector3(0, 1, 0));

            base.Initialize();
        }

        /// <summary>
        /// LoadContent will be called once per game and is the place to load
        /// all of your content.
        /// </summary>
        protected override void LoadContent()
        {
            // Create a new SpriteBatch, which can be used to draw textures.
            spriteBatch = new SpriteBatch(GraphicsDevice);

            efekt.Texture = this.Content.Load<Texture2D>("Ziemia");
            efekt.TextureEnabled = true;
            //dla walca
            //efekt.World = Matrix.CreateRotationX(-MathHelper.PiOver2) * Matrix.CreateTranslation(0, -0.5f, 0);
            //dla sfery
            efekt.World = Matrix.CreateRotationX(-MathHelper.PiOver2);
        }

        /// <summary>
        /// UnloadContent will be called once per game and is the place to unload
        /// all content.
        /// </summary>
        protected override void UnloadContent()
        {
            // TODO: Unload any non ContentManager content here
        }

        /// <summary>
        /// Allows the game to run logic such as updating the world,
        /// checking for collisions, gathering input, and playing audio.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Update(GameTime gameTime)
        {
            // Allows the game to exit
            if (GamePad.GetState(PlayerIndex.One).Buttons.Back == ButtonState.Pressed)
                this.Exit();

            //klawiatura
            if (Keyboard.GetState().IsKeyDown(Keys.Escape)) this.Exit();
            if (Keyboard.GetState().IsKeyDown(Keys.Space)) graphics.ToggleFullScreen();            

            if (Keyboard.GetState().IsKeyDown(Keys.Up)) efekt.World *= Matrix.CreateRotationX(-0.01f);
            if (Keyboard.GetState().IsKeyDown(Keys.Down)) efekt.World *= Matrix.CreateRotationX(0.01f);

            efekt.World *= Matrix.CreateRotationY(gameTime.ElapsedGameTime.Milliseconds / 3000.0f);
            
            base.Update(gameTime);
        }

        /// <summary>
        /// This is called when the game should draw itself.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Draw(GameTime gameTime)
        {
            //graphics.GraphicsDevice.Clear(Color.CornflowerBlue);            

            // TODO: Add your drawing code here                    
            GraphicsDevice gd = graphics.GraphicsDevice;
            gd.Clear(Color.Black);
            //gd.RenderState.CullMode = CullMode.CullCounterClockwiseFace;
            gd.RasterizerState = RasterizerState.CullNone;

            sfera.Rysuj(efekt);

            base.Draw(gameTime);
        }
    }
}
